package com.qboxus.tictic.viewModels

import android.content.Context
import android.content.SharedPreferences
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.viewModelScope
import com.google.firebase.database.DataSnapshot
import com.google.firebase.database.DatabaseError
import com.qboxus.tictic.Constants
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.interfaces.FirebaseChatCallback
import com.qboxus.tictic.models.InboxModel
import com.qboxus.tictic.models.UserModel
import com.qboxus.tictic.repositories.WalletRepository
import com.qboxus.tictic.simpleclasses.FirebaseChatUtil
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Variables
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.launch
import org.json.JSONObject

class InboxViewModel(
    private val context: Context
):ViewModel() {

    private val _actualList = MutableStateFlow<List<InboxModel>>(emptyList())

    private val _inboxList = MutableStateFlow<List<InboxModel>>(emptyList())
    val inboxList: StateFlow<List<InboxModel>> = _inboxList


    init {
        loadInboxData()
    }

    private fun loadInboxData() {
        FirebaseChatUtil.registerUserInbox(context,object : FirebaseChatCallback {
            override fun onDataChange(dataSnapshot: DataSnapshot) {
                val tempList = mutableListOf<InboxModel>()
                for (ds in dataSnapshot.children) {
                    val model = ds.getValue(InboxModel::class.java)
                    model!!.id = ds.key
                    if (model != null) tempList.add(model)
                }
                _actualList.value=tempList
                _inboxList.value = tempList

            }

            override fun onCancelled(databaseError: DatabaseError) {}
        })
    }


    fun filteredInboxList(query: String) {
        Functions.printLog(Constants.tag,"query$query")
         if (query.isEmpty()) {
             _inboxList.value = _actualList.value

        }
        else {
             _inboxList.value = _actualList.value.filter {
                 it.name.lowercase().contains(query)
                         || it.msg.lowercase().contains(query)
             }
         }

    }
}
